/*
 * Decompiled with CFR 0.152.
 */
package jace;

import jace.EmulatorUILogic;
import jace.apple2e.Apple2e;
import jace.config.Configuration;
import jace.core.Computer;
import jace.ui.MainFrame;
import java.awt.Canvas;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class Emulator {
    public static Emulator instance;
    public Apple2e computer = new Apple2e();
    public MainFrame theApp;

    public static void main(String[] args) {
        instance = new Emulator();
    }

    public Emulator() {
        Configuration.loadSettings();
        this.theApp = new MainFrame();
        try {
            this.theApp.setIconImage(ImageIO.read(Emulator.class.getClassLoader().getResourceAsStream("jace/data/woz_figure.gif")));
        }
        catch (IOException ex) {
            Logger.getLogger(Emulator.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.theApp.setVisible(true);
        this.theApp.setDefaultCloseOperation(3);
        this.theApp.setFocusTraversalKeysEnabled(false);
        this.theApp.screen.setFocusTraversalKeysEnabled(false);
        this.theApp.setTitle("Java Apple Computer Emulator");
        Emulator.resizeVideo();
        this.theApp.addKeyListener(this.computer.getKeyboard().getListener());
        this.theApp.screen.addKeyListener(this.computer.getKeyboard().getListener());
        this.theApp.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Emulator.resizeVideo();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                Emulator.resizeVideo();
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.theApp.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
                Computer.getComputer().getVideo().suspend();
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                Computer.getComputer().getVideo().resume();
                Emulator.resizeVideo();
            }

            @Override
            public void windowActivated(WindowEvent e) {
                Emulator.resizeVideo();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                Emulator.resizeVideo();
            }
        });
        EmulatorUILogic.registerDebugger();
        this.computer.getVideo().setScreen(this.theApp.screen.getGraphics());
        this.computer.coldStart();
    }

    public static void resizeVideo() {
        MainFrame window = MainFrame.instance;
        JPanel debugger = MainFrame.instance.debugger;
        Canvas screen = MainFrame.instance.screen;
        screen.setSize(window.getContentPane().getWidth() - debugger.getWidth() + 1, window.getContentPane().getHeight());
        Computer.getComputer().getVideo().setWidth(screen.getWidth());
        Computer.getComputer().getVideo().setHeight(screen.getHeight());
        debugger.revalidate();
        Computer.getComputer().getVideo().markDirty();
    }
}

